<?php
/*
Plugin Name: Divi Background Plus
Plugin URI:  https://besuperfly.com/product/divi-background-plus/
Description: Add solid color, gradient, image or video as its own element as a background within a Divi section, row or single column. Add an Animated Gradient to your Section background! Supports Visual Builder!
Version:     2.5
Author:      BeSuperfly
Author URI:  https://besuperfly.com/
License:     GPL2
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: dbp-divi-background-plus
Domain Path: /languages
*/

global $divi_background_plus_version;
$divi_background_plus_version = '2.5';

// API Licensing
if ( ! class_exists( 'WC_AM_Client_2_7' ) ) {
    require_once( plugin_dir_path( __FILE__ ) . 'wc-am-client.php' );
}
if ( class_exists( 'WC_AM_Client_2_7' ) ) {
    /**
     * This file is only an example that includes a plugin header, and this code used to instantiate the client object. The variable $wcam_lib
     * can be used to access the public properties from the WC_AM_Client class, but $wcam_lib must have a unique name. To find data saved by
     * the WC_AM_Client in the options table, search for wc_am_client_{product_id}, so in this example it would be wc_am_client_13.
     *
     * All data here is sent to the WooCommerce API Manager API, except for the $software_title, which is used as a title, and menu label, for
     * the API Key activation form the client will see.
     *
     * ****
     * NOTE
     * ****
     * If $product_id is empty, the customer can manually enter the product_id into a form field on the activation screen.
     *
     * @param string $file             Must be __FILE__ from the root plugin file, or theme functions, file locations.
     * @param int    $product_id       Must match the Product ID number (integer) in the product.
     * @param string $software_version This product's current software version.
     * @param string $plugin_or_theme  'plugin' or 'theme'
     * @param string $api_url          The URL to the site that is running the API Manager. Example: https://www.toddlahman.com/
     * @param string $software_title   The name, or title, of the product. The title is not sent to the API Manager APIs, but is used for menu titles.
     *
     */

    global $divi_background_plus_version;
    global $divi_background_plus_api;
    $divi_background_plus_api = new WC_AM_Client_2_7( __FILE__, 216973, $divi_background_plus_version, 'plugin', 'https://besuperfly.com/', 'Divi Background Plus' );
}


if ( ! function_exists( 'dbp_initialize_extension' ) ):
/**
 * Creates the extension's main class instance.
 *
 * @since 1.0.0
 */
function dbp_initialize_extension() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/DiviBackgroundPlus.php';
}
add_action( 'divi_extensions_init', 'dbp_initialize_extension' );
endif;
