<?php
/*
* Plugin Name: Divi Header Customizer
* Plugin URI: https://besuperfly.com/products/divi-header-customizer/
* Description: Customize headings appeareance from Customizer. <strong>For this module to work you need the Divi theme or a Divi child theme to be active</strong>
* Author: BeSuperfly
* Version: 1.1.1
* Author URI: https://besuperfly.com
* License: GPL3
* Text Domain: divi_header_customizer
*/

global $dhc_version;
$dhc_version = '1.1.1';

// API Licensing
if ( ! class_exists( 'WC_AM_Client_2_7' ) ) {
	require_once( plugin_dir_path( __FILE__ ) . 'wc-am-client.php' );
}
if ( class_exists( 'WC_AM_Client_2_7' ) ) {
	/**
	 * This file is only an example that includes a plugin header, and this code used to instantiate the client object. The variable $wcam_lib
	 * can be used to access the public properties from the WC_AM_Client class, but $wcam_lib must have a unique name. To find data saved by
	 * the WC_AM_Client in the options table, search for wc_am_client_{product_id}, so in this example it would be wc_am_client_13.
	 *
	 * All data here is sent to the WooCommerce API Manager API, except for the $software_title, which is used as a title, and menu label, for
	 * the API Key activation form the client will see.
	 *
	 * ****
	 * NOTE
	 * ****
	 * If $product_id is empty, the customer can manually enter the product_id into a form field on the activation screen.
	 *
	 * @param string $file             Must be __FILE__ from the root plugin file, or theme functions, file locations.
	 * @param int    $product_id       Must match the Product ID number (integer) in the product.
	 * @param string $software_version This product's current software version.
	 * @param string $plugin_or_theme  'plugin' or 'theme'
	 * @param string $api_url          The URL to the site that is running the API Manager. Example: https://www.toddlahman.com/
	 * @param string $software_title   The name, or title, of the product. The title is not sent to the API Manager APIs, but is used for menu titles.
	 *
	 */

	global $dhc_version;
	global $dhc_wc_api;
	$dhc_wc_api = new WC_AM_Client_2_7( __FILE__, '502080', $dhc_version, 'plugin', 'https://besuperfly.com/', 'Divi Header Customizer' );
}

$headingcustomizer_settings=array(
	'version' => '1.0.1',
	'transient_html' => 'headingcustomizer_t_html_style',
	'transient_fonts' => 'headingcustomizer_t_fonts_to_load',
	'settings_variable' => 'headingcustomizer',
	'text_domain' => 'divi_header_customizer',
	'sections' => 'headingcustomizer_section_',
	'heading_min' => 1,
	'heading_max' => 6,
	'google_fonts' => 'headingcustomizer_google_fonts'
);
$headingcustomizer_site_size=array(
	'desktop'=>'Desktop',
	'tablet'=>'Tablet',
	'mobile'=>'Mobile'
);
$headingcustomizer_site_size_modify=array(
	'desktop'=>array(
		'font_size' => 0
	),
	'tablet'=>array(
		'font_size' => -10
	),
	'mobile'=>array(
		'font_size' => -20
	)
);
$headingcustomizer_enqueuefonts=array();


defined( 'ABSPATH' ) or die( 'Finding the mouse pointer on screen...' );

if( !function_exists('headingcustomizer_check_if_run') ){
	function headingcustomizer_check_if_run(){
		if( function_exists( 'et_get_theme_version' ) ){ return true; }
		else return false;
	}
}

if( !function_exists('headingcustomizer_get_url_data') ){
	function headingcustomizer_get_url_data($url)
	{
		if (!function_exists('curl_init')){ 
			die('CURL is not installed!');
		}
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$output = curl_exec($ch);
		curl_close($ch);
		return $output;
	}
}

if( !function_exists('headingcustomizer_customizer_change') ){
	function headingcustomizer_customizer_change($wp_customize)
	{
		if( headingcustomizer_check_if_run() ){
			global $headingcustomizer_site_size,$headingcustomizer_site_size_modify,$headingcustomizer_settings,$google_fonts;
			// CUSTOM HTML ELEMENT IN CUSTOMIZER
			class HeadingCustomizerTextOnlyControl extends WP_Customize_Control {
				public $type = 'textonly';
				public $heading = 1;
				public function render_content() {?>
					<h<?php echo $this->heading; ?>><?php echo esc_html( $this->label ); ?></h<?php echo $this->heading; ?>>
				<?php
				}
			}
			class HeadingCustomizerEmptySpaceControl extends WP_Customize_Control {
				public $type = 'emptyspace';
				public $hide_hr = false;
				public function render_content() {?> <br /><br /><?php if( $this->hide_hr!=true ) echo '<hr /><br />'; ?><?php }
			}
			// CUSTOM HTML ELEMENT IN CUSTOMIZER
			
			// MAKE FONTS LIST

			$site_domain = get_locale();

			$google_fonts = et_builder_get_fonts( array(
				'prepend_standard_fonts' => false,
			) );

			$user_fonts = et_builder_get_custom_fonts();

			// combine google fonts with custom user fonts
			$google_fonts = array_merge( $user_fonts, $google_fonts );

			$et_domain_fonts = array(
				'ru_RU' => 'cyrillic',
				'uk'    => 'cyrillic',
				'bg_BG' => 'cyrillic',
				'vi'    => 'vietnamese',
				'el'    => 'greek',
				'ar'    => 'arabic',
				'he_IL' => 'hebrew',
				'th'    => 'thai',
				'si_lk' => 'sinhala',
				'bn_bd' => 'bengali',
				'ta_lk' => 'tamil',
				'te'    => 'telegu',
				'km'    => 'khmer',
				'kn'    => 'kannada',
				'ml_in' => 'malayalam',
			);

			$et_one_font_languages = et_get_one_font_languages();

			$font_choices = array();
			$font_choices['none'] = array(
				'label' => 'Default Theme Font'
			);

			$removed_fonts_mapping = et_builder_old_fonts_mapping();

			foreach ( $google_fonts as $google_font_name => $google_font_properties ) {
				$use_parent_font = false;

				if ( isset( $removed_fonts_mapping[ $google_font_name ] ) ) {
					$parent_font = $removed_fonts_mapping[ $google_font_name ]['parent_font'];
					$google_font_properties['character_set'] = $google_fonts[ $parent_font ]['character_set'];
					$use_parent_font = true;
				}

				if ( '' !== $site_domain && isset( $et_domain_fonts[$site_domain] ) && isset( $google_font_properties['character_set'] ) && false === strpos( $google_font_properties['character_set'], $et_domain_fonts[$site_domain] ) ) {
					continue;
				}

				$font_choices[ $google_font_name ] = array(
					'label' => $google_font_name,
					'data'  => array(
						'parent_font'    => $use_parent_font ? $google_font_properties['parent_font'] : '',
						'parent_styles'  => $use_parent_font ? $google_fonts[$parent_font]['styles'] : $google_font_properties['styles'],
						'current_styles' => $use_parent_font && isset( $google_fonts[$parent_font]['styles'] ) && isset( $google_font_properties['styles'] ) ? $google_font_properties['styles'] : '',
						'parent_subset'  => $use_parent_font && isset( $google_fonts[$parent_font]['character_set'] ) ? $google_fonts[$parent_font]['character_set'] : '',
						'standard'       => isset( $google_font_properties['standard'] ) && $google_font_properties['standard'] ? 'on' : 'off',
					)
				);
			}
			
			global $dhc_wc_api;
			if($dhc_wc_api->get_api_key_status()) {
			// ADD SECTIONS
				$wp_customize->add_panel( $headingcustomizer_settings['sections'].'main' , array(
					'title'		=> esc_html__( 'Customize Heading Elements', $headingcustomizer_settings['text_domain'] ),
					'priority'	=> 99999,
				) );
				
				for($h=$headingcustomizer_settings['heading_min'];$h<=$headingcustomizer_settings['heading_max'];$h++){
					$wp_customize->add_section($headingcustomizer_settings['sections'].'h'.$h.'_section', array(
						'title' => __('H'.$h.' Tag', $headingcustomizer_settings['text_domain']),
						'panel' => $headingcustomizer_settings['sections'].'main',
					));
					
					// ADD INPUTS
					foreach($headingcustomizer_site_size as $s=>$v){
						// Inner Title
						$wp_customize->add_setting($headingcustomizer_settings['settings_variable'].'_text_'.$h.'_'.$s, array(
								'default' => '',
								'type' => 'textonly_control',
								'capability' => 'edit_theme_options',
								'transport' => 'postMessage',
							)
						);
						$wp_customize->add_control( new HeadingCustomizerTextOnlyControl( $wp_customize, $headingcustomizer_settings['settings_variable'].'_text_'.$h.'_'.$s, array(
								'label' => $v,
								'heading' => 1,
								'section' => $headingcustomizer_settings['sections'].'h'.$h.'_section',
								'settings' => $headingcustomizer_settings['settings_variable'].'_text_'.$h.'_'.$s,
							) ) 
						);
						
						// Font Sizes
						$size=49-($h*2); // default font-size based on Heading
						$size=$size+$headingcustomizer_site_size_modify[$s]['font_size'];  // default font-size based on Screen Size
						$wp_customize->add_setting( $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_font_size]', array(
							'default'       => $size,
							'type'          => 'option',
							'capability'    => 'edit_theme_options',
							'transport'     => 'refresh',
							'sanitize_callback' => 'absint',
						) );
						
						$wp_customize->add_control( new ET_Divi_Range_Option ( $wp_customize, $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_font_size]', array(
							'label'	      => esc_html__( 'Text Size', $headingcustomizer_settings['text_domain'] ),
							'section'     => $headingcustomizer_settings['sections'].'h'.$h.'_section',
							'type'        => 'range',
							'input_attrs' => array(
								'min'  => 10,
								'max'  => 200,
								'step' => 1
							),
						) ) );
						
						// Line Height
						$wp_customize->add_setting( $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_height]', array(
							'default'       => '1',
							'type'          => 'option',
							'capability'    => 'edit_theme_options',
							'transport'     => 'refresh',
							'sanitize_callback' => 'et_sanitize_float_number',
						) );

						$wp_customize->add_control( new ET_Divi_Range_Option ( $wp_customize, $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_height]', array(
							'label'	      => esc_html__( 'Line Height', $headingcustomizer_settings['text_domain'] ),
							'section'     => $headingcustomizer_settings['sections'].'h'.$h.'_section',
							'type'        => 'range',
							'input_attrs' => array(
								'min'  => 0.8,
								'max'  => 3,
								'step' => 0.1
							),
						) ) );
						
						// Letter Spacing
						$wp_customize->add_setting( $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_spacing]', array(
							'default'       => '0',
							'type'          => 'option',
							'capability'    => 'edit_theme_options',
							'transport'     => 'refresh',
							'sanitize_callback' => 'et_sanitize_int_number',
						) );

						$wp_customize->add_control( new ET_Divi_Range_Option ( $wp_customize, $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_spacing]', array(
							'label'	      => esc_html__( 'Letter Spacing', $headingcustomizer_settings['text_domain'] ),
							'section'     => $headingcustomizer_settings['sections'].'h'.$h.'_section',
							'type'        => 'range',
							'input_attrs' => array(
								'min'  => -2,
								'max'  => 10,
								'step' => 1
							),
						) ) );
						
						// Header Style
						$wp_customize->add_setting( $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_style]', array(
							'default'       => '',
							'type'          => 'option',
							'capability'    => 'edit_theme_options',
							'transport'     => 'refresh',
							'sanitize_callback' => 'et_sanitize_font_style',
						) );

						$wp_customize->add_control( new ET_Divi_Font_Style_Option ( $wp_customize, $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_style]', array(
							'label'	      => esc_html__( 'Font Style', $headingcustomizer_settings['text_domain'] ),
							'section'     => $headingcustomizer_settings['sections'].'h'.$h.'_section',
							'type'        => 'font_style',
							'choices'     => et_divi_font_style_choices(),
						) ) );
						
						// Header Font Family
						$wp_customize->add_setting( $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_font]', array(
							'default'		=> 'none',
							'type'			=> 'option',
							'capability'	=> 'edit_theme_options',
							'transport'		=> 'refresh',
						) );

						$wp_customize->add_control( new ET_Divi_Select_Option ( $wp_customize, $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_font]', array(
							'label'		=> esc_html__( 'Font', $headingcustomizer_settings['text_domain'] ),
							'section'	=> $headingcustomizer_settings['sections'].'h'.$h.'_section',
							'settings'	=> $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_font]',
							'type'		=> 'select',
							'choices'	=> $font_choices,
						) ) );
						
						// Empty Space
						$wp_customize->add_setting($headingcustomizer_settings['settings_variable'].'_emptyspaceb_'.$h.'_'.$s, array(
								'default' => '',
								'type' => 'emptyspace_control',
								'capability' => 'edit_theme_options',
								'transport' => 'postMessage',
							)
						);
						$wp_customize->add_control( new HeadingCustomizerEmptySpaceControl( $wp_customize, $headingcustomizer_settings['settings_variable'].'_emptyspaceb_'.$h.'_'.$s, array(
								'section' => $headingcustomizer_settings['sections'].'h'.$h.'_section',
								'settings' => $headingcustomizer_settings['settings_variable'].'_text_'.$h.'_'.$s,
								'hide_hr' => true
							) ) 
						);
						
						// Header Color Style
						$wp_customize->add_setting( $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_color_style]', array(
							'type'			=> 'option',
							'capability'	=> 'edit_theme_options',
							'transport'		=> 'refresh',
							'sanitize_callback' => 'wp_validate_boolean',
						) );

						$wp_customize->add_control( $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_color_style]', array(
							'label'		=> esc_html__( 'Gradient header color', $headingcustomizer_settings['text_domain'] ),
							'section'	=> $headingcustomizer_settings['sections'].'h'.$h.'_section',
							'type'      => 'checkbox',
						) );
						
						// Header Gradient
							// Header Gradient Direction
							$wp_customize->add_setting( $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_gradient_direction]', array(
								'default'		=> 'vertical',
								'type'			=> 'option',
								'capability'	=> 'edit_theme_options',
								'transport'		=> 'refresh'
							) );

							$wp_customize->add_control( new ET_Divi_Select_Option ( $wp_customize, $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_gradient_direction]', array(
								'label'		=> esc_html__( 'Gradient Direction', $headingcustomizer_settings['text_domain'] ),
								'section'	=> $headingcustomizer_settings['sections'].'h'.$h.'_section',
								'settings'	=> $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_gradient_direction]',
								'type'		=> 'select',
								'choices'	=> array(
										'vertical'=>array( 'label'=>'Vertical'),
										'horizontal'=>array( 'label'=>'Horizontal'),
										'diagonal_lefttop_rightbottom'=>array( 'label'=>'Diagonal &#8600;'),
										'diagonal_righttop_leftbottom'=>array( 'label'=>'Diagonal &#8601;'),
								),
							) ) );
							
							// Header Gradient Color 1
							$wp_customize->add_control( new ET_Divi_Customize_Color_Alpha_Control( $wp_customize, $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_gradient_color_1]', array(
								'label'		=> esc_html__( 'Gradient Color 1', $headingcustomizer_settings['text_domain'] ),
								'section'	=> $headingcustomizer_settings['sections'].'h'.$h.'_section',
								'settings'	=> $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_gradient_color_1]',
							) ) );

							$wp_customize->add_setting( $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_gradient_color_1]', array(
								'default'		=> '',
								'type'			=> 'option',
								'capability'	=> 'edit_theme_options',
								'transport'		=> 'refresh',
								'sanitize_callback' => 'et_sanitize_alpha_color',
							) );

							$wp_customize->add_control( new ET_Divi_Customize_Color_Alpha_Control( $wp_customize, $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_gradient_color_1]', array(
								'label'		=> esc_html__( 'Gradient Color 1', $headingcustomizer_settings['text_domain'] ),
								'section'	=> $headingcustomizer_settings['sections'].'h'.$h.'_section',
								'settings'	=> $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_gradient_color_1]',
							) ) );
							
							// Header Gradient Color 2
							$wp_customize->add_control( new ET_Divi_Customize_Color_Alpha_Control( $wp_customize, $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_gradient_color_2]', array(
								'label'		=> esc_html__( 'Gradient Color 2', $headingcustomizer_settings['text_domain'] ),
								'section'	=> $headingcustomizer_settings['sections'].'h'.$h.'_section',
								'settings'	=> $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_gradient_color_2]',
							) ) );

							$wp_customize->add_setting( $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_gradient_color_2]', array(
								'default'		=> '',
								'type'			=> 'option',
								'capability'	=> 'edit_theme_options',
								'transport'		=> 'refresh',
								'sanitize_callback' => 'et_sanitize_alpha_color',
							) );

							$wp_customize->add_control( new ET_Divi_Customize_Color_Alpha_Control( $wp_customize, $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_gradient_color_2]', array(
								'label'		=> esc_html__( 'Gradient Color 2', $headingcustomizer_settings['text_domain'] ),
								'section'	=> $headingcustomizer_settings['sections'].'h'.$h.'_section',
								'settings'	=> $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_gradient_color_2]',
							) ) );
						
						// Header Solid Color
						$wp_customize->add_control( new ET_Divi_Customize_Color_Alpha_Control( $wp_customize, $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_header_color]', array(
							'label'		=> esc_html__( 'Text Color', $headingcustomizer_settings['text_domain'] ),
							'section'	=> $headingcustomizer_settings['sections'].'h'.$h.'_section',
							'settings'	=> $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_header_color]',
						) ) );

						$wp_customize->add_setting( $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_header_color]', array(
							'default'		=> '',
							'type'			=> 'option',
							'capability'	=> 'edit_theme_options',
							'transport'		=> 'refresh',
							'sanitize_callback' => 'et_sanitize_alpha_color',
						) );

						$wp_customize->add_control( new ET_Divi_Customize_Color_Alpha_Control( $wp_customize, $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_header_color]', array(
							'label'		=> esc_html__( 'Text Color', $headingcustomizer_settings['text_domain'] ),
							'section'	=> $headingcustomizer_settings['sections'].'h'.$h.'_section',
							'settings'	=> $headingcustomizer_settings['settings_variable'].'[h'.$h.'_'.$s.'_header_color]',
						) ) );
						
						// Empty Space
						$wp_customize->add_setting($headingcustomizer_settings['settings_variable'].'_emptyspace_'.$h.'_'.$s, array(
								'default' => '',
								'type' => 'emptyspace_control',
								'capability' => 'edit_theme_options',
								'transport' => 'postMessage',
							)
						);
						$wp_customize->add_control( new HeadingCustomizerEmptySpaceControl( $wp_customize, $headingcustomizer_settings['settings_variable'].'_emptyspace_'.$h.'_'.$s, array(
								'section' => $headingcustomizer_settings['sections'].'h'.$h.'_section',
								'settings' => $headingcustomizer_settings['settings_variable'].'_text_'.$h.'_'.$s,
							) ) 
						);
					}
					// ADD INPUTS
				}
				// ADD SECTIONS
			}
		}
	}
}
add_action('customize_register', 'headingcustomizer_customizer_change' , 11);

if( !function_exists('headingcustomizer_customize_customizer') ){
	function  headingcustomizer_customize_customizer() {
		global $headingcustomizer_settings;
		wp_enqueue_script( $headingcustomizer_settings['settings_variable'].'-controls-js', plugins_url( '/customizer.js', __FILE__ ), array( 'jquery' ), $headingcustomizer_settings['version'], true );
	}
}

if( !function_exists('headingcustomizer_make_css_html') ){
	function headingcustomizer_make_css_html($array,$screen,$heading)
	{
		$css=false;
		// Font Sizes
		$setting='h'.$heading.'_'.$screen.'_font_size';
		if( isset($array[$setting]) ){ $css[]='font-size: '.$array[$setting].'px'; }
		// Line Height
		$setting='h'.$heading.'_'.$screen.'_height';
		if( isset($array[$setting]) ){ $css[]='line-height: '.$array[$setting].'em'; }
		// Letter Spacing
		$setting='h'.$heading.'_'.$screen.'_spacing';
		if( isset($array[$setting]) ){ $css[]='letter-spacing: '.$array[$setting].'px'; }
		// Style
		$setting='h'.$heading.'_'.$screen.'_style';
		if( isset($array[$setting]) ){
			$array[$setting]=explode('|',$array[$setting]);
			foreach($array[$setting] as $value)
			{
				switch($value)
				{
					case "bold": $css[]='font-weight: bold'; break;
					case "italic": $css[]='font-style: italic'; break;
					case "uppercase": $css[]='text-transform: uppercase'; break;
					case "underline": $css[]='text-decoration: underline'; break;
				}
			}
		}
		// Font Family
		$setting='h'.$heading.'_'.$screen.'_font';
		if( isset($array[$setting]) && $array[$setting]!="none" && $array[$setting]!=""){
			global $headingcustomizer_enqueuefonts;
			$headingcustomizer_enqueuefonts[]=$array[$setting];
			$css[]='font-family: "'.$array[$setting].'"';
		}
		// Font Color
		$setting='h'.$heading.'_'.$screen.'_color_style';
		if( isset($array[$setting]) && $array[$setting]==1 ){
			
		}
		else{
			$setting='h'.$heading.'_'.$screen.'_header_color';
			if( isset($array[$setting]) && $array[$setting]!="" ){
				$css[]='color: '.$array[$setting];
			}
		}
		
		if( is_array($css) ) { $css=implode('; ',$css); $css .= ';'; }

		return $css;
	}
}

if( !function_exists('headingcustomizer_make_css_html_gradient') ){
	function headingcustomizer_make_css_html_gradient($settings,$screen,$heading)
	{
		$html="";
		$direction=$settings['h'.$heading.'_'.$screen.'_gradient_direction'];
		$color_1=$settings['h'.$heading.'_'.$screen.'_gradient_color_1'];
		$color_2=$settings['h'.$heading.'_'.$screen.'_gradient_color_2'];
		
		switch($direction){
			case "horizontal": $direction="90deg, "; break;
			case "diagonal_lefttop_rightbottom": $direction="170deg, "; break;
			case "diagonal_righttop_leftbottom": $direction="-170deg, "; break;
			default: $direction="180deg, ";
		}
		
		$html=' background: '.$color_1.'; background-image: -webkit-linear-gradient( '.$direction.$color_1.', '.$color_2.' ); background-image: -o-linear-gradient( '.$direction.$color_1.', '.$color_2.' ); background-image: -moz-linear-gradient( '.$direction.$color_1.', '.$color_2.' ); background-image: linear-gradient( '.$direction.$color_1.', '.$color_2.' ); -webkit-background-clip: text; -webkit-text-fill-color: transparent; display: inline-block; ';
		return $html;
	}
}

if( !function_exists('headingcustomizer_echo_changes') ){
	function headingcustomizer_echo_changes($fonts_to_load,$html_style)
	{
		if(is_array($fonts_to_load) && $fonts_to_load!="" && $fonts_to_load!="none"){
			global $google_fonts;
			foreach($fonts_to_load as $single_font){
				if($single_font!=""){
					$fonts=get_transient( $headingcustomizer_settings['google_fonts'] );
					$protocol = is_ssl() ? 'https' : 'http';


					if ( isset( $fonts[ $single_font ]['parent_font'] ) ){
						$single_font = $fonts[ $single_font ]['parent_font'];
					}
					$font_character_set = $fonts[ $single_font ]['other_data']->subsets;

					$query_args = array(
						'family' => sprintf( '%s:%s',
							str_replace( ' ', '+', $single_font ),
							apply_filters( 'et_builder_set_styles', $fonts[ $single_font ]['other_data']->variants, $single_font )
						),
						'subset' => apply_filters( 'et_builder_set_character_set', $font_character_set, $single_font ),
					);

					$font_name_slug = sprintf(
						'et-gf-%1$s',
						strtolower( str_replace( ' ', '-', $single_font ) )
					);
					unset($fonts);
					wp_enqueue_style( $font_name_slug, esc_url( add_query_arg( $query_args, "$protocol://fonts.googleapis.com/css" ) ), array(), null );
				}
			}
		}
		echo $html_style;
	}
}

if( !function_exists('headingcustomizer_regenerate_trasient') ){
	function headingcustomizer_regenerate_trasient($settings,$return_data=0)
	{
		global $headingcustomizer_site_size,$headingcustomizer_enqueuefonts, $wp_styles, $headingcustomizer_settings;
		$html = '<!-- AB custom CSS --><style>';
		foreach($headingcustomizer_site_size as $s=>$v)
		{
			switch($s)
			{
				case "desktop": $html .= '
				/* DESKTOP */
				@media all and (min-width: 981px){ '; break;
				case "tablet": $html .= '
				/* TABLET */
				@media all and (min-width: 768px) and (max-width: 980px){ '; break;
				case "mobile": $html .= '
				/* MOBILE */
				@media all and (max-width: 767px){ '; break;
			}
			
			for($h=$headingcustomizer_settings['heading_min'];$h<=$headingcustomizer_settings['heading_max'];$h++)
			{
				$css=headingcustomizer_make_css_html($settings,$s,$h);
				if( $css!=false)
				{
					$html .= '
					body .et_pb_column_1_3 h'.$h.', body .et_pb_column_1_4 h'.$h.',
					body .et_pb_column_1_2 h'.$h.', body .et_pb_column_4_4 h'.$h.',
					body .et_pb_text h'.$h.',
					body h'.$h.'{ '.$css.' }';
					if( isset($settings['h'.$h.'_'.$s.'_color_style']) && $settings['h'.$h.'_'.$s.'_color_style']==1 ){
						$html .= '
						/* HEADING'.$h.' GRADIENT */
						body h'.$h.'{ '.headingcustomizer_make_css_html_gradient($settings,$s,$h).' } ';
					}
				}
			}
			switch($s)
			{
				case "desktop": $html .= '
				}'; break;
				case "tablet": $html .= '
				}'; break;
				case "mobile": $html .= '
				}
			'; break;
			}
		}
		$html .= '</style>';
		
		$fonts_to_load=array();
		foreach( $wp_styles->queue as $style )
		{
		   $loaded_fonts[] =  $wp_styles->registered[$style]->handle;
		}
		foreach ( $headingcustomizer_enqueuefonts as $single_font )
		{
			$font_name= 'et-gf-'.strtolower( str_replace( ' ', '-', $single_font ) );
			if( !in_array( $font_name , $loaded_fonts ) ){
				$fonts_to_load[]=$single_font;
			}
		}
		
		if($return_data==1) return array( $html , $fonts_to_load );
		
		set_transient( $headingcustomizer_settings['transient_html'], $html, DAY_IN_SECONDS );
		set_transient( $headingcustomizer_settings['transient_fonts'], $fonts_to_load, DAY_IN_SECONDS );
	}
}

if( !function_exists('headingcustomizer_main_function') ){
	function headingcustomizer_main_function()
	{
		global $headingcustomizer_settings;

		$is_admin=is_admin();
		
		if( isset($_POST['wp_customize']) && $_POST['wp_customize']=='on' )
		{
			$settings=get_option($headingcustomizer_settings['settings_variable'], false);
			
			$changed=$_POST['customized'];
			$changed=json_decode(stripslashes($changed), true);
			foreach($changed as $k=>$change)
			{
				$k=str_replace("[", "", str_replace("]", "", strstr($k, '[')));
				$settings[$k]=$change;
			}
			$data=headingcustomizer_regenerate_trasient($settings,1);
			headingcustomizer_echo_changes($data[1],$data[0]);
		}
		else{
			$settings=get_option($headingcustomizer_settings['settings_variable'], false);
			if($settings!=false)
			{
				$html_style = get_transient( $headingcustomizer_settings['transient_html'] );
				$fonts_to_load = get_transient( $headingcustomizer_settings['transient_fonts'] );

				headingcustomizer_regenerate_trasient($settings);
				
				$html_style = get_transient( $headingcustomizer_settings['transient_html'] );
				$fonts_to_load = get_transient( $headingcustomizer_settings['transient_fonts'] );
				if ( $is_admin==false ) headingcustomizer_echo_changes($fonts_to_load,$html_style);
			}
		}
	}
}

if( !function_exists('remove_header_settings') ){
	function remove_header_settings($wp_customize) {
		$wp_customize->remove_setting("et_divi[body_header_size]");
		$wp_customize->remove_control("et_divi[body_header_size]");

		$wp_customize->remove_setting("et_divi[body_header_spacing]");
		$wp_customize->remove_control("et_divi[body_header_spacing]");

		$wp_customize->remove_setting("et_divi[body_header_height]");
		$wp_customize->remove_control("et_divi[body_header_height]");

		$wp_customize->remove_setting("et_divi[body_header_style]");
		$wp_customize->remove_control("et_divi[body_header_style]");

		$wp_customize->remove_setting("et_divi[phone_header_font_size]");
		$wp_customize->remove_control("et_divi[phone_header_font_size]");

		$wp_customize->remove_setting("et_divi[tablet_header_font_size]");
		$wp_customize->remove_control("et_divi[tablet_header_font_size]");

		$wp_customize->remove_setting("et_divi[tablet_header_font_size]");
		$wp_customize->remove_control("et_divi[tablet_header_font_size]");

		$wp_customize->remove_setting("et_divi[heading_font]");
		$wp_customize->remove_control("et_divi[heading_font]");

		$wp_customize->remove_setting("et_divi[header_color]");
		$wp_customize->remove_control("et_divi[header_color]");
	}
}

if( !function_exists('headingcustomizer_init') ){
	function headingcustomizer_init() {
		if( headingcustomizer_check_if_run() ){
			add_action( 'customize_controls_enqueue_scripts', 'headingcustomizer_customize_customizer' );
			add_action('wp_head', 'headingcustomizer_main_function', 999);
			add_action( 'customize_register', 'remove_header_settings', 999);
		}
		else
		{
			add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'headingcustomizer_add_action_links', 10, 2 );
		}
	}
	function headingcustomizer_add_action_links( $actions, $plugin_file ) {
		$actions['divi_active'] = '<a href="'.admin_url( 'themes.php').'"><strong style="display: inline;">Go to Themes</strong></a>';
		return $actions;
	}
}
add_action( 'init', 'headingcustomizer_init' , 9999 );