<?php
/*
Plugin Name: Divi SOS - Simple Overlay Solution
Plugin URI:  https://besuperfly.com/
Description: Build custom overlays and mega menus using the Divi Builder and trigger them on any link click or automatically after a delay.
Version:     1.3.2
Author:      BeSuperfly
Author URI:  https://besuperfly.com/
*/

global $sosVersion;
$sosVersion = '1.3.2';

// API Licensing
if ( ! class_exists( 'WC_AM_Client_2_7' ) ) {
    require_once( plugin_dir_path( __FILE__ ) . 'wc-am-client.php' );
}
if ( class_exists( 'WC_AM_Client_2_7' ) ) {
    /**
     * This file is only an example that includes a plugin header, and this code used to instantiate the client object. The variable $wcam_lib
     * can be used to access the public properties from the WC_AM_Client class, but $wcam_lib must have a unique name. To find data saved by
     * the WC_AM_Client in the options table, search for wc_am_client_{product_id}, so in this example it would be wc_am_client_13.
     *
     * All data here is sent to the WooCommerce API Manager API, except for the $software_title, which is used as a title, and menu label, for
     * the API Key activation form the client will see.
     *
     * ****
     * NOTE
     * ****
     * If $product_id is empty, the customer can manually enter the product_id into a form field on the activation screen.
     *
     * @param string $file             Must be __FILE__ from the root plugin file, or theme functions, file locations.
     * @param int    $product_id       Must match the Product ID number (integer) in the product.
     * @param string $software_version This product's current software version.
     * @param string $plugin_or_theme  'plugin' or 'theme'
     * @param string $api_url          The URL to the site that is running the API Manager. Example: https://www.toddlahman.com/
     * @param string $software_title   The name, or title, of the product. The title is not sent to the API Manager APIs, but is used for menu titles.
     *
     */

    global $sosVersion;
    global $sos_wc_api;
    $sos_wc_api = new WC_AM_Client_2_7( __FILE__, '486877', $sosVersion, 'plugin', 'https://besuperfly.com/', 'Divi SOS' );
}

function divi_sos_add_layout_loader_page() {
    if($sos_existing_layout_loader = get_page_by_title( 'Divi SOS Layout Loader' )) {
        wp_delete_post($sos_existing_layout_loader->ID, true);
    }
    
    $sos_layout_loader = array(
        'post_title'    => wp_strip_all_tags( 'Divi SOS Layout Loader' ),
        'post_content'  => 'This page is part of the SOS plugin. DO NOT EDIT OR DELETE THIS PAGE.',
        'post_status'   => 'publish',
        'post_author'   => 1,
        'post_type'     => 'page',
    );

    // Insert the post into the database
    wp_insert_post($sos_layout_loader);

    // Soft flush permalink cache
    global $wp_rewrite; 
    $wp_rewrite->flush_rules(false);
}
register_activation_hook(__FILE__, 'divi_sos_add_layout_loader_page');

add_filter( 'page_template', 'divi_sos_page_template' );
function divi_sos_page_template( $page_template ) {
    $divi_sos_layout_loader = get_page_by_title('Divi SOS Layout Loader');
    if (is_page($divi_sos_layout_loader->ID)) {
        $page_template = dirname( __FILE__ ) . '/divi-sos-layout-loader.php';
    }
    return $page_template;
}

function register_divi_sos_category( $taxonomy, $object_type, $array_taxonomy_object ) { 
	if($taxonomy == 'layout_category') {
		if(!term_exists('divi_sos', 'layout_category')) {
			wp_insert_term('SOS Layouts', 'layout_category', array('slug' => 'divi_sos'));
		}
	}
};
add_action( 'registered_taxonomy', 'register_divi_sos_category', 10, 3 ); 

// Add SOS menu only if allowed for current user
function divi_sos_add_divi_menu() {
    add_submenu_page( 'et_divi_options', esc_html__( 'Divi SOS', 'Divi' ), esc_html__( 'SOS', 'Divi' ), 'manage_options', 'edit.php?s&post_status=all&post_type=et_pb_layout&layout_category=divi_sos' );
}
add_action('admin_menu', 'divi_sos_add_divi_menu', 100, 1);

function divi_sos_meta_box_markup($object) {
    wp_nonce_field(basename(__FILE__), "divi-sos-nonce"); ?>
	<p class="post-attributes-label-wrapper">
		<label class="post-attributes-label" for="meta-divi-sos-id">Trigger this Layout Overlay by setting the HREF of any link to:</label>
	</p>
	<input type="text" name="meta-divi-sos-id" value="#divi-sos-<?php echo $object->ID; ?>">
    <button class="button button-secondary" id="divi-sos-copy-id">Copy</button>
    <hr>
    <p class="post-attributes-label-wrapper">
        <label class="post-attributes-label" for="meta-divi-sos-preload">Preload Layout <input type="checkbox" name="meta-divi-sos-preload" value="1" <?php echo get_post_meta($object->ID, "meta-divi-sos-preload", true) == true ? 'checked' : ''; ?>></label>
        <p style="margin-top: 0;">Enabling this option will load this overlay on every page. This will show the overlay instantly when triggered, but may increase page load time.</p>
    </p>
    <hr>
    <p class="post-attributes-label-wrapper">
        <label class="post-attributes-label" for="meta-divi-sos-automatic">Show Automatically <input type="checkbox" name="meta-divi-sos-automatic" value="1" <?php echo get_post_meta($object->ID, "meta-divi-sos-automatic", true) == true ? 'checked' : ''; ?>></label>
    </p>
    <div id="divi-sos-automatic-delay" style="display: none;">
        <p class="post-attributes-label-wrapper">
            <label class="post-attributes-label" for="meta-divi-sos-automatic-delay">Delay (in milliseconds)</label>
        </p>
        <input type="number" name="meta-divi-sos-automatic-delay" value="<?php echo get_post_meta($object->ID, "meta-divi-sos-automatic-delay", true) ? get_post_meta($object->ID, "meta-divi-sos-automatic-delay", true) : 1000; ?>">
        <p class="post-attributes-label-wrapper">
            <label class="post-attributes-label" for="meta-divi-sos-cookie">Only Show Once <input type="checkbox" name="meta-divi-sos-cookie" value="1" <?php echo get_post_meta($object->ID, "meta-divi-sos-cookie", true) == true ? 'checked' : ''; ?>></label>
            <em>Use a cookie to only show once per device. Cookie expires after 30 days.</em>
        </p>
    </div>
    <hr>
    <p class="post-attributes-label-wrapper">
        <label class="post-attributes-label" for="meta-divi-sos-transition">Transition</label>
    </p>
    <select name="meta-divi-sos-transition">
        <option value="fade" <?php echo get_post_meta($object->ID, "meta-divi-sos-transition", true) == 'fade' ? 'selected' : ''; ?>>Fade</option>
        <option value="slide" <?php echo get_post_meta($object->ID, "meta-divi-sos-transition", true) == 'slide' ? 'selected' : ''; ?>>Slide</option>
        <option value="none" <?php echo get_post_meta($object->ID, "meta-divi-sos-transition", true) == 'none' ? 'selected' : ''; ?>>None</option>
    </select>
    <p class="post-attributes-label-wrapper">
        <label class="post-attributes-label" for="meta-divi-sos-background">Background</label>
    </p>
    <select name="meta-divi-sos-background">
        <option value="dark" <?php echo get_post_meta($object->ID, "meta-divi-sos-background", true) == 'dark' ? 'selected' : ''; ?>>Dark</option>
        <option value="light" <?php echo get_post_meta($object->ID, "meta-divi-sos-background", true) == 'light' ? 'selected' : ''; ?>>Light</option>
        <option value="none" <?php echo get_post_meta($object->ID, "meta-divi-sos-background", true) == 'none' ? 'selected' : ''; ?>>None</option>
    </select>
    <p class="post-attributes-label-wrapper">
        <label class="post-attributes-label" for="meta-divi-sos-loader">Loader Color</label>
    </p>
    <select name="meta-divi-sos-loader">
        <option value="dark" <?php echo get_post_meta($object->ID, "meta-divi-sos-loader", true) == 'dark' ? 'selected' : ''; ?>>Dark</option>
        <option value="light" <?php echo get_post_meta($object->ID, "meta-divi-sos-loader", true) == 'light' ? 'selected' : ''; ?>>Light</option>
    </select>
    <hr>
    <p class="post-attributes-label-wrapper">
        <label class="post-attributes-label" for="meta-divi-sos-close">Show Close Button <input type="checkbox" name="meta-divi-sos-close" value="1" <?php echo get_post_meta($object->ID, "meta-divi-sos-close", true) == true ? 'checked' : ''; ?>></label>
    </p>
    <div id="divi-sos-close-color" style="display: none;">
        <p class="post-attributes-label-wrapper">
            <label class="post-attributes-label" for="meta-divi-sos-close-color">Close Button Color</label>
        </p>
        <input type="text" name="meta-divi-sos-close-color" data-alpha="true" value="<?php echo get_post_meta($object->ID, "meta-divi-sos-close-color", true) ? get_post_meta($object->ID, "meta-divi-sos-close-color", true) : '#000000'; ?>">
        <p class="post-attributes-label-wrapper">
            <label class="post-attributes-label" for="meta-divi-sos-close-background-color">Close Button Background Color</label>
        </p>
        <input type="text" name="meta-divi-sos-close-background-color" data-alpha="true" value="<?php echo get_post_meta($object->ID, "meta-divi-sos-close-background-color", true) ? get_post_meta($object->ID, "meta-divi-sos-close-background-color", true) : ''; ?>">
    </div>    
	<?php 
}

function divi_sos_add_meta_box() {
    if( isset($_GET['post']) && get_post($_GET['post']) && isset($_GET['action']) && 'edit' == $_GET['action'] ) {
        $post = get_post($_GET['post']);
        if($post->post_type == 'et_pb_layout' && has_term('divi_sos', 'layout_category', $post)) {
            if ( function_exists('et_pb_is_allowed') && et_pb_is_allowed( 'divi_library' ) ) {
                add_meta_box('divi-sos-meta-box', 'Divi SOS - Layout Overlays', 'divi_sos_meta_box_markup', array('et_pb_layout'), 'side', 'high', null);
            }        
        }
    }	
}
add_action('add_meta_boxes', 'divi_sos_add_meta_box');

function divi_sos_save_meta_box($post_id, $post, $update) {
    if (!isset($_POST["divi-sos-nonce"]) || !wp_verify_nonce($_POST["divi-sos-nonce"], basename(__FILE__)))
        return $post_id;

    if(!current_user_can("edit_post", $post_id))
        return $post_id;

    if(defined("DOING_AUTOSAVE") && DOING_AUTOSAVE)
        return $post_id;

    $slugs = array('et_pb_layout', 'post');
    if(!in_array($post->post_type, $slugs))
        return $post_id;

    $divi_sos_id = '';
    $divi_sos_automatic = false;
    $divi_sos_preaload = false;
    $divi_sos_automatic_delay = 0;
    $divi_sos_cookie = false;
    $divi_sos_type = '';
    $divi_sos_transition = '';
    $divi_sos_background = '';
    $divi_sos_close = false;
    $divi_sos_close_color = '';
    $divi_sos_close_background_color = '';
    $divi_sos_preload = '';
    
    if(isset($_POST["meta-divi-sos-id"])) {
        $divi_sos_id = $_POST["meta-divi-sos-id"];
    }
    update_post_meta($post_id, "meta-divi-sos-id", $divi_sos_id);

    if(isset($_POST["meta-divi-sos-preload"])) {
        if($_POST["meta-divi-sos-preload"]) {
            $divi_sos_preload = true;
        }
    }
    update_post_meta($post_id, "meta-divi-sos-preload", $divi_sos_preload);

    if(isset($_POST["meta-divi-sos-automatic"])) {
        if($_POST["meta-divi-sos-automatic"]) {
            $divi_sos_automatic = true;

            if(isset($_POST["meta-divi-sos-automatic-delay"])) {
                $divi_sos_automatic_delay = $_POST["meta-divi-sos-automatic-delay"];
            }
        }
    }
    update_post_meta($post_id, "meta-divi-sos-automatic", $divi_sos_automatic);
    update_post_meta($post_id, "meta-divi-sos-automatic-delay", $divi_sos_automatic_delay);

    if(isset($_POST["meta-divi-sos-cookie"])) {
        if($_POST["meta-divi-sos-cookie"]) {
            $divi_sos_cookie = true;
        }
    }
    update_post_meta($post_id, "meta-divi-sos-cookie", $divi_sos_cookie);

    if(isset($_POST["meta-divi-sos-transition"])) {
        $divi_sos_transition = $_POST["meta-divi-sos-transition"];
    }
    update_post_meta($post_id, "meta-divi-sos-transition", $divi_sos_transition);

    if(isset($_POST["meta-divi-sos-background"])) {
        $divi_sos_background = $_POST["meta-divi-sos-background"];
    }
    update_post_meta($post_id, "meta-divi-sos-background", $divi_sos_background);

    if(isset($_POST["meta-divi-sos-loader"])) {
        $divi_sos_loader = $_POST["meta-divi-sos-loader"];
    }
    update_post_meta($post_id, "meta-divi-sos-loader", $divi_sos_loader);

    if(isset($_POST["meta-divi-sos-close"])) {
        if($_POST["meta-divi-sos-close"]) {
            $divi_sos_close = true;
        }
    }
    update_post_meta($post_id, "meta-divi-sos-close", $divi_sos_close);

    if(isset($_POST["meta-divi-sos-close-color"])) {
        $divi_sos_close_color = $_POST["meta-divi-sos-close-color"];
    }
    update_post_meta($post_id, "meta-divi-sos-close-color", $divi_sos_close_color);

    if(isset($_POST["meta-divi-sos-close-background-color"])) {
        $divi_sos_close_background_color = $_POST["meta-divi-sos-close-background-color"];
    }
    update_post_meta($post_id, "meta-divi-sos-close-background-color", $divi_sos_close_background_color);
}
add_action("save_post", "divi_sos_save_meta_box", 10, 3);

function divi_sos_enqueue() {
    global $sosVersion;

	wp_enqueue_style('divi-sos', plugins_url( '/css/divi-sos.css', __FILE__ ), array(), $sosVersion);
    wp_enqueue_script('divi-sos', plugins_url( '/js/divi-sos.min.js', __FILE__ ), array('jquery'), $sosVersion);
    $layouts = array();
    $layoutPosts = get_posts(array(
        'post_type' => 'et_pb_layout',
        'tax_query' => array(
            array(
                'taxonomy'          => 'layout_category',
                'field'             => 'slug',
                'terms'             => 'divi_sos'
            ),
        ),
        'posts_per_page'    => -1,
        'numberposts'       => -1
    ));
    foreach($layoutPosts as $layoutPost) {
        $layouts[$layoutPost->ID] = array(
            'iframe' => '<iframe class="divi-sos-iframe" src="' . add_query_arg('divi_sos_layout_id', $layoutPost->ID, get_permalink(get_page_by_title('Divi SOS Layout Loader'))) . '" scrolling="yes"></iframe>',
            'transition' => get_post_meta($layoutPost->ID, "meta-divi-sos-transition", true),
            'background' => get_post_meta($layoutPost->ID, "meta-divi-sos-background", true),
            'loader' => get_post_meta($layoutPost->ID, "meta-divi-sos-loader", true),
            'close' => get_post_meta($layoutPost->ID, "meta-divi-sos-close", true),
            'close_color' => get_post_meta($layoutPost->ID, "meta-divi-sos-close-color", true),
            'close_background_color' => get_post_meta($layoutPost->ID, "meta-divi-sos-close-background-color", true),
            'automatic' => get_post_meta($layoutPost->ID, "meta-divi-sos-automatic", true),
            'automatic_delay' => get_post_meta($layoutPost->ID, "meta-divi-sos-automatic-delay", true),
            'cookie' => get_post_meta($layoutPost->ID, "meta-divi-sos-cookie", true),
            'preload' => get_post_meta($layoutPost->ID, "meta-divi-sos-preload", true)
        );
    }
    wp_localize_script( 'divi-sos', 'divi_sos', array(
    	'ajaxurl' => admin_url('admin-ajax.php'),
        'layouts' => $layouts
    ));    
}
add_action( 'wp_enqueue_scripts', 'divi_sos_enqueue' );

function divi_sos_admin_enqueue() {
    global $sosVersion;

    // CSS
	wp_enqueue_style('divi-sos-admin', plugins_url( '/css/divi-sos-admin.css', __FILE__ ), array(), $sosVersion);	
    wp_enqueue_style( 'wp-color-picker');

	// JS	
	wp_enqueue_script('divi-sos-admin', plugins_url( '/js/divi-sos-admin.min.js', __FILE__ ), array('jquery'), $sosVersion);
    wp_enqueue_script( 'wp-color-picker');
}
add_action( 'admin_enqueue_scripts', 'divi_sos_admin_enqueue' );