jQuery(function($) {
	$.each(divi_sos.layouts, function(key, layout) {
		// Autoshow
		if(layout.automatic && window.location.href.indexOf('et_fb=1') == -1) {
			window.setTimeout(function() {
				// If cookie is set
				if(layout.cookie && diviSosGetCookie('divi_sos')) {
					// Convert string cookie to array
					diviSosCookie = diviSosGetCookie('divi_sos').split(',');

					// If not in array, show overlay and add to array
					if(diviSosCookie.indexOf(key) == -1) {
						diviSosCookie.push(key);
						diviSosSetCookie('divi_sos', diviSosCookie.toString());
						diviSosShowOverlay(key);	
					}
				}
				// If cookie is not set
				else {
					diviSosSetCookie('divi_sos', key);
					diviSosShowOverlay(key);
				}
			}, layout.automatic_delay);
		}

		// Preloaded
		if(layout.preload) {
			// Add markup if necessary			
			diviSosMarkup = '<div id="divi-sos-overlay-' + key + '" class="divi-sos-overlay divi-sos-transition-' + layout.transition + ' divi-sos-loader-' + layout.loader + '">';
			diviSosMarkup += layout.iframe;
			diviSosMarkup += '<div class="divi-sos-iframe-loader"></div>';
			if(layout.close) {
				diviSosMarkup += '<a class="divi-sos-close-button" href="#divi-sos-close" style="color: ' + layout.close_color + '; background-color: ' + layout.close_background_color + ';"></a>';
			}
			diviSosMarkup += '</div>';
			if($('#et-main-area').length) {
				$('#et-main-area').prepend(diviSosMarkup);	
			}
			else {
				$('#main-content').prepend(diviSosMarkup);	
			}
			$('#divi-sos-overlay-' + key + ' iframe').load(function(){
		        $('#divi-sos-overlay-' + key).addClass('divi-sos-iframe-loaded');
		        $('#divi-sos-overlay-' + key + ' .sos-iframe-loader').remove();
		    });			
		}
	});	

	// Close when mobile menu icon is clicked
	$('.mobile_menu_bar_toggle').click(function(e) {
		if($('body').hasClass('divi-sos-active')) {
			diviSosCloseOverlay();
		}
	});

	if(typeof et_link_options_data != 'undefined') {
		$.each(et_link_options_data, function(i, link) {
			if(link.url.startsWith('#divi-sos-')) {
				$('.' + link.class).click(function(e) {
					e.preventDefault();
					diviSosOverlayId = link.url.substr(10);
					diviSosHandleClick(diviSosOverlayId);
				});
			}
		});
	}

	$('body').on('click', '*[href^="#divi-sos-"]', function(e) {

		e.preventDefault();
		href = $(this).attr('href');
		diviSosOverlayId = href.substr(10);
		diviSosHandleClick(diviSosOverlayId);		
	});

	// Handle clicks separately so you can use any type of element (instead of just those with href attribute)
	function diviSosHandleClick(diviSosOverlayId) {
		// Close
		if(diviSosOverlayId == 'close') {
			diviSosCloseOverlay();
		}

		// Open
		else {
			// If one is open
			if($('.divi-sos-overlay.active').length) {
				diviSosCurrentOverlayId = $('.divi-sos-overlay.active').attr('id').substr(17);
				
				$('.divi-sos-overlay.active.divi-sos-transition-fade').fadeOut(function() {
					//$('.divi-sos-overlay.divi-sos-transition-fade').remove();
					$(this).removeClass('active');
					$('body').removeClass('divi-sos-active');
					if(diviSosCurrentOverlayId != diviSosOverlayId) {						
						diviSosShowOverlay(diviSosOverlayId)						
					}
				});
				$('.divi-sos-overlay.active.divi-sos-transition-slide').slideUp(function() {
					//$('.divi-sos-overlay.divi-sos-transition-slide').remove();
					$(this).removeClass('active');
					$('body').removeClass('divi-sos-active');
					if(diviSosCurrentOverlayId != diviSosOverlayId) {
						diviSosShowOverlay(diviSosOverlayId)
					}
				});
				$('.divi-sos-overlay.active.divi-sos-transition-none').hide(function() {
					//$('.divi-sos-overlay.divi-sos-transition-none').remove();
					$('body').removeClass('divi-sos-active');
					$(this).removeClass('active');
					if(diviSosCurrentOverlayId != diviSosOverlayId) {
						diviSosShowOverlay(diviSosOverlayId)
					}
				});
			}
			else {
				diviSosShowOverlay(diviSosOverlayId);
			}
		}
	}

	diviSosCloseOverlay = function($diviSosOverlay) {
		$diviSosOverlay = $('.divi-sos-overlay.active');
		if($diviSosOverlay.hasClass('divi-sos-transition-fade')) {
			$diviSosOverlay.fadeOut(function() {
				//$(this).remove();
				$(this).removeClass('active');
				$('body').removeClass('divi-sos-active');
			});	
		}
		if($diviSosOverlay.hasClass('divi-sos-transition-slide')) {
			$diviSosOverlay.slideUp(function() {
				//$(this).remove();
				$(this).removeClass('active');
				$('body').removeClass('divi-sos-active');
			});	
		}
		if($diviSosOverlay.hasClass('divi-sos-transition-none')) {
			$diviSosOverlay.hide().removeClass('active');//.remove();
			$('body').removeClass('divi-sos-active');
		}

		// Reset iframe videos
		if($diviSosOverlay.find('iframe').length) {
			$diviSosOverlay.find('iframe')[0].contentWindow.diviSosResetVideos();
		}
	}

	function diviSosShowOverlay(diviSosOverlayId) {
		$('body').removeClass('divi-sos-light divi-sos-dark');
		if(divi_sos.layouts[diviSosOverlayId].background) {
			if(divi_sos.layouts[diviSosOverlayId].background == 'dark') {
				$('body').addClass('divi-sos-dark');
			}
			else if(divi_sos.layouts[diviSosOverlayId].background == 'light') {
				$('body').addClass('divi-sos-light');
			}
		}

		// Add markup if necessary
		if(!$('#divi-sos-overlay-' + diviSosOverlayId).length) {
			diviSosMarkup = '<div id="divi-sos-overlay-' + diviSosOverlayId + '" class="divi-sos-overlay divi-sos-transition-' + divi_sos.layouts[diviSosOverlayId]['transition'] + ' divi-sos-loader-' + divi_sos.layouts[diviSosOverlayId]['loader'] + '">';
			diviSosMarkup += divi_sos.layouts[diviSosOverlayId]['iframe'];
			diviSosMarkup += '<div class="divi-sos-iframe-loader"></div>';
			if(divi_sos.layouts[diviSosOverlayId]['close']) {
				diviSosMarkup += '<a class="divi-sos-close-button" href="#divi-sos-close" style="color: ' + divi_sos.layouts[diviSosOverlayId]['close_color'] + '; background-color: ' + divi_sos.layouts[diviSosOverlayId]['close_background_color'] + ';"></a>';
			}
			diviSosMarkup += '</div>';
			if($('#et-main-area').length) {
				$('#et-main-area').prepend(diviSosMarkup);	
			}
			else {
				$('#main-content').prepend(diviSosMarkup);	
			}
			$('#divi-sos-overlay-' + diviSosOverlayId + ' iframe').load(function(){
		        $('#divi-sos-overlay-' + diviSosOverlayId).addClass('divi-sos-iframe-loaded');
		        window.setTimeout(function() {
		        	$('#divi-sos-overlay-' + diviSosOverlayId + ' .sos-iframe-loader').remove();
		        }, 200);
		    });
		}

		window.setTimeout(function() {
			$('body').addClass('divi-sos-active');
		});

		$('#divi-sos-overlay-' + diviSosOverlayId + '.divi-sos-overlay.divi-sos-transition-fade').fadeIn(function() {
			$(this).addClass('active');
		});
		$('#divi-sos-overlay-' + diviSosOverlayId + '.divi-sos-overlay.divi-sos-transition-slide').slideDown(function() {
			$(this).addClass('active');
		});
		$('#divi-sos-overlay-' + diviSosOverlayId + '.divi-sos-overlay.divi-sos-transition-none').show(function() {
			$(this).addClass('active');
		});
	}

	function diviSosSetCookie(name, value) {
	    var expires = "";    
	    var date = new Date();
	    date.setTime(date.getTime() + (30*24*60*60*1000)); // 30 days
	    expires = "; expires=" + date.toUTCString();    
	    document.cookie = name + "=" + (value || "")  + expires + "; path=/";
	}

	function diviSosGetCookie(name) {
	    var nameEQ = name + "=";
	    var ca = document.cookie.split(';');
	    for(var i=0;i < ca.length;i++) {
	        var c = ca[i];
	        while (c.charAt(0)==' ') c = c.substring(1,c.length);
	        if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
	    }
	    return null;
	}
});